﻿#include <iostream>
#include <string>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <unordered_map>
#include <random>
#include <chrono>

using namespace std;
using ll = long long;
using pii = pair<int, int>;
ll INF = 1e18;
ll NINF = -1e18;

mt19937 rnd(chrono::high_resolution_clock::now().time_since_epoch().count());

struct SegTreeNode {
	int val;
	int sz;
	int sum;
	SegTreeNode() {
		val = 0;
		sz = 1;
		sum = 0;
	}
	SegTreeNode(int x) {
		val = x;
		sz = 1;
		sum = x;
	}
};

struct SegTree {
	vector<SegTreeNode> t;
	vector<int> push;
	vector<int> orig;
	SegTree(vector<int>& a) {
		orig = a;
		t.resize(4 * orig.size());
		push.resize(4 * orig.size());
		build(0, 0, orig.size());
	}

	void build(int v, int l, int r) {
		if (l + 1 == r) {
			t[v] = SegTreeNode(orig[l]);
		}
		else {
			int m = (l + r) / 2;
			build(2 * v + 1, l, m);
			build(2 * v + 2, m, r);
			t[v].sum = t[2 * v + 1].sum + t[2 * v + 2].sum;
		}
	}

	int get(int v, int l, int r, int ql, int qr) {
		if (qr <= l || r <= ql) {
			return 0;
		}
		if (ql <= l && r <= qr) {
			return t[v].sum;
		}
		int m = (l + r) / 2;
		int a = get(2 * v + 1, l, m, ql, qr);
		int b = get(2 * v + 2, m, r, ql, qr);
		return a + b;
	}
};

bool isPal(int x) {
	string s;
	while (x > 0) {
		s += (char)('0' + (x % 10));
		x /= 10;
	}
	string temp = s;
	reverse(s.begin(), s.end());
	if (temp == s) return true;
	return false;
}

int main() {
	int dp[1000];
	for (int i = 0; i < 1000; ++i) dp[i] = 100000;
	vector<int> pals;
	for (int i = 1; i < 10; ++i) {
		dp[i] = 1;
		pals.push_back(i);
	}
	for (int i = 10; i < 1000; ++i) {
		if (isPal(i)) {
			dp[i] = 1;
			pals.push_back(i);
		} else {
			for (int p : pals) {
				dp[i] = min(dp[i], 1 + dp[i - p]);
			}
		}
	}
	int t, x;
	cin >> t;
	while (t--) {
		cin >> x;
		cout << dp[x] << endl;
	}
}